<?php

namespace App\Controllers;

use App\Models\EducationModel;

class EducationController extends BaseController
{
    protected $educationModel;

    public function __construct()
    {
        $this->educationModel = new EducationModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search') ?? '';
        $filter = [
            'jenjang' => $this->request->getGet('jenjang') ?? '',
            'tahun_mulai' => $this->request->getGet('tahun_mulai') ?? '',
            'tahun_selesai' => $this->request->getGet('tahun_selesai') ?? '',
            'status_pendidikan' => $this->request->getGet('status_pendidikan') ?? ''
        ];
        $sort = $this->request->getGet('sort') ?? 'urutan';
        $order = $this->request->getGet('order') ?? 'ASC';
        $page = (int)($this->request->getGet('page') ?? 1);

        $builder = $this->educationModel->searchAndFilter($search, $filter, $sort, $order);
        $total = $builder->countAllResults(false);
        
        $perPage = 10;
        $education = $builder->get($perPage, ($page - 1) * $perPage)->getResultArray();

        $pager = \Config\Services::pager();
        $pager->store('education', $page, $perPage, $total);
        
        // Calculate last page manually to ensure it works
        $lastPage = (int) ceil($total / $perPage);

        $data = [
            'title' => 'Riwayat Pendidikan - Portfolio',
            'education' => $education,
            'pager' => $pager,
            'lastPage' => $lastPage,
            'currentPage' => $page,
            'total' => $total,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order
        ];

        return view('education/index', $data);
    }
}

